package ru.yandex.chemodan.util;

import java.net.InetAddress;
import java.util.stream.Stream;

import lombok.SneakyThrows;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.dynproperties.DynamicPropertyContainer;

public class HostBasedSwitch implements DynamicPropertyContainer {

    private final DynamicProperty<ListF<String>> property;

    public HostBasedSwitch(String name) {
        this.property = DynamicProperty.cons(name, Cf.list());
    }

    @SneakyThrows
    private static boolean matches(String host) {
        return Stream.of("any", InetAddress.getLocalHost().getHostName()).anyMatch(host.trim()::equalsIgnoreCase);
    }

    public boolean get() {
        return property.get().exists(HostBasedSwitch::matches);
    }

}
