package ru.yandex.chemodan.util;

import java.io.IOException;
import java.io.InputStream;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import org.skyscreamer.jsonassert.JSONAssert;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.InputStreamX;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class JsonAssert {

    private static final JsonParser parser = new JsonParser();

    public static void equals(Class<?> aClass, String expectedJsonFilename, byte[] actualJson) {
        equals(aClass, expectedJsonFilename, new String(actualJson));
    }

    public static void equals(Class<?> aClass, String expectedJsonFilename, String actualJson) {
        equals(aClass.getResourceAsStream(expectedJsonFilename), actualJson);
    }

    public static void equals(InputStream expectedJson, String actualJson) {
        try (InputStream in = expectedJson) {
            equals(new InputStreamX(in).readString(), actualJson);
        } catch (IOException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    public static void equals(String expected, String actual) {
        Assert.equals(
                parseJson("expected", expected),
                parseJson("actual", actual)
        );
    }

    private static JsonElement parseJson(String description, String json) {
        try {
            return parser.parse(json);
        } catch (JsonSyntaxException e) {
            Assert.fail(String.format("%s json has invalid syntax: %s\n%s", description, e.getMessage(), json));
            throw e;
        }
    }

    public static void equalsLenient(Class<?> aClass, String filename, byte[] actualJson) {
        equalsLenient(aClass, filename, new String(actualJson));
    }

    public static void equalsLenient(Class<?> aClass, String filename, String actualStr) {
        equalsLenient(readFile(aClass, filename), actualStr);
    }

    private static String readFile(Class<?> aClass, String filename) {
        return new InputStreamX(aClass.getResourceAsStream(filename)).readString();
    }

    public static void equalsLenient(String expectedStr, String actualStr) {
        JSONAssert.assertEquals(expectedStr, actualStr, false);
    }
}
