package ru.yandex.chemodan.util;

import java.util.function.Supplier;

/**
 * Not thread-safe
 * @param <T>
 */
public class MemoizedSupplier<T> implements Supplier<T> {

    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        return new MemoizedSupplier<>(delegate);
    }

    private final Supplier<T> delegate;

    private T value;

    private MemoizedSupplier(Supplier<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T get() {
        if (value == null) {
            value = delegate.get();
        }
        return value;
    }
}
