package ru.yandex.chemodan.util;

import java.lang.reflect.ParameterizedType;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.FieldX;
import ru.yandex.misc.reflection.MemberX;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class ReflectionUtils {

    @SuppressWarnings("unchecked")
    private static <T> T get(FieldX field, Object target) {
        return (T) field.<FieldX>setAccessibleTrueReturnThis().get(target);
    }

    public static <T> T getFieldValue(Object target, Class<T> valueClass, String fieldName) {
        FieldX field = ClassX.wrap(target.getClass()).getDeclaredField(fieldName);
        Assert.isTrue(field.getType().isAssignableTo(valueClass));

        return get(field, target);
    }

    public static Object getField(Object target, String fieldName) {
        FieldX field = ClassX.wrap(target.getClass()).getDeclaredField(fieldName);
        return get(field, target);
    }

    public static <T> ListF<T> getFieldListValue(Object target, Class<T> valueClass, String fieldName) {
        FieldX field = ClassX.wrap(target.getClass()).getDeclaredField(fieldName);
        ParameterizedType type = field.getGenericType().asParameterizedType();

        Assert.isTrue(field.getType().isAssignableTo(ListF.class));
        Assert.equals(valueClass, type.getActualTypeArguments()[0]);

        return get(field, target);
    }

    public static void setFieldValue(Object target, String fieldName, Object value) {
        ClassX.wrap(target.getClass()).getDeclaredField(fieldName)
                .<FieldX>setAccessibleTrueReturnThis()
                .set(target, value);
    }

    public static ListF<String> getAllFieldNames(Class<?> clazz) {
        if (clazz == null) {
            return Cf.list();
        }

        ListF<String> result = Cf.toArrayList(getAllFieldNames(clazz.getSuperclass()));
        result.addAll(ClassX.wrap(clazz).getAllDeclaredFields().map(MemberX::getName));
        return result;
    }
}
