package ru.yandex.chemodan.util;

import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.collection.ListF;

/**
 * @author dbrylev
 */
public class SingleOrList<T> {
    private final Either<T, ListF<T>> either;

    public SingleOrList(Either<T, ListF<T>> either) {
        this.either = either;
    }

    public static <T> SingleOrList<T> single(T value) {
        return new SingleOrList<>(Either.left(value));
    }

    public static <T> SingleOrList<T> list(ListF<T> list) {
        return new SingleOrList<>(Either.right(list));
    }

    public boolean isSingle() {
        return either.isLeft();
    }

    public T getSingle() {
        return either.getLeft();
    }

    public ListF<T> getList() {
        return either.getRight();
    }
}
