package ru.yandex.chemodan.util;

import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.LocalTime;

import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.random.Random2;

/**
 * @author akirakozov
 */
public class TimeUtils {
    public static int unixTime(Instant time) {
        return (int) (time.getMillis() / 1000);
    }

    public static int unixTimeTill(Instant mTill) {
        return unixTime(mTill) - 1;
    }

    public static Instant randomTimeOnNextDay(DateTime now, int hourFrom, int hourTo) {
        return randomTimeOnDay(now, hourFrom, hourTo, 1);
    }

    public static Instant randomTimeOnCurrentDay(DateTime now, int hourFrom, int hourTo) {
        return randomTimeOnDay(now, hourFrom, hourTo, 0);
    }

    public static Instant randomTimeOnDay(DateTime now, int hourFrom, int hourTo, int days) {
        return randomTimeOnDay(Random2.R, now, hourFrom, hourTo, days);
    }

    public static Instant randomTimeOnDay(Random2 R, DateTime now, int hourFrom, int hourTo, int days) {
        Validate.isTrue(hourTo > hourFrom && hourFrom < 24 && hourTo < 24);
        int minutes = R.nextInt((int) Duration.standardHours(hourTo - hourFrom).getStandardMinutes());
        int seconds = R.nextInt(60);
        return now.withTimeAtStartOfDay()
                .plusDays(days).plusHours(hourFrom).plusMinutes(minutes).plusSeconds(seconds).toInstant();
    }

    public static long unixMicrosecods() {
        java.time.Instant now = java.time.Instant.now();
        return now.getEpochSecond() * 1000000 + now.getNano() / 1000;
    }

    public static boolean between(LocalTime after, LocalTime before, LocalTime time) {
        if (after.isAfter(before)) {
            return time.isAfter(after) || time.isBefore(before);
        }

        return time.isAfter(after) && time.isBefore(before);
    }

    public static boolean nowBetween(LocalTime after, LocalTime before) {
        return between(after, before, LocalTime.now());
    }
}
