package ru.yandex.chemodan.util;

import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalTime;
import org.junit.Test;

import ru.yandex.misc.test.Assert;
import ru.yandex.misc.time.InstantInterval;
import ru.yandex.misc.time.MoscowTime;

/**
 * @author akirakozov
 */
public class TimeUtilsTest {

    @Test
    public void randomTimeOnNextDay() throws Exception {
        DateTime now = new DateTime(2016, 10, 03, 13, 12, 18, MoscowTime.TZ);
        Instant time = TimeUtils.randomTimeOnNextDay(now, 18, 20);
        InstantInterval interval = new InstantInterval(
                new DateTime(2016, 10, 04, 18, 00, 00, MoscowTime.TZ),
                new DateTime(2016, 10, 04, 20, 00, 00, MoscowTime.TZ));

        Assert.isTrue(interval.contains(time));
    }

    @Test
    public void betweenTest() {
        LocalTime first = new LocalTime(6, 0);
        LocalTime second = new LocalTime(18, 0);

        LocalTime afterFirstBeforeSecond = new LocalTime(12, 0);
        LocalTime afterSecondBeforeMidnight = new LocalTime(20, 0);
        LocalTime afterMidnightBeforeFirst = new LocalTime(2, 0);

        Assert.isTrue(TimeUtils.between(first, second, afterFirstBeforeSecond));
        Assert.isFalse(TimeUtils.between(second, first, afterFirstBeforeSecond));

        Assert.isFalse(TimeUtils.between(first, second, afterSecondBeforeMidnight));
        Assert.isTrue(TimeUtils.between(second, first, afterSecondBeforeMidnight));

        Assert.isFalse(TimeUtils.between(first, second, afterMidnightBeforeFirst));
        Assert.isTrue(TimeUtils.between(second, first, afterMidnightBeforeFirst));
    }
}
