package ru.yandex.chemodan.util;

import java.util.function.Function;

import org.joda.time.Duration;
import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class WaitInCycleTest {
    @Test
    public void testCondition() {
        int resultCycles = new WaitInCycle<Integer>(Duration.millis(10), Duration.millis(100))
                .repeatWhile(cycle -> cycle < 3)
                .call(new Function<Duration, Integer>() {
                    int cycle = 0;
                    @Override
                    public Integer apply(Duration duration) {
                        return cycle++;
                    }
                });

        Assert.le(resultCycles, 3);
    }

    @Test
    public void testTotalDuration() {
        Duration expectedDuration = Duration.millis(100);
        WaitInCycle<Void> voidWaitInCycle = new WaitInCycle<>(Duration.millis(30), expectedDuration);
        long start = System.nanoTime();
        voidWaitInCycle
                .call(duration -> {
                    try {
                        Thread.sleep(duration.getMillis());
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return null;
                });
        Duration actualDuration = Duration.millis((System.nanoTime() - start) / 1000000);

        if (Math.abs(actualDuration.minus(expectedDuration).getMillis()) > 200) {
            Assert.fail("Expected duration = " + expectedDuration + " differs from"
                    + " actual = " + actualDuration
                    + " more than 200 ms");
        }
    }
}
