package ru.yandex.chemodan.util;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.misc.env.Environment;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.net.HostnameUtils;

/**
 * @author dbrylev
 */
public class ZkUtils extends ru.yandex.commune.zk2.ZkUtils {

    public static ZkPath rootPath(String serviceName, EnvironmentType environmentType) {
        String environmentId;

        if (!Environment.isDeveloperNotebook()
                || environmentType != EnvironmentType.DEVELOPMENT && environmentType != EnvironmentType.TESTS)
        {
            environmentId = environmentType.name().toLowerCase();
        } else {
            environmentId = HostnameUtils.localHostname();
        }
        return new ZkPath("/" + serviceName + "/" + environmentId);
    }
}
