package ru.yandex.chemodan.util.auth;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.log.DiskLog4jRequestLog;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author friendlyevil
 */
public final class YateamAuthUtils {

    public static Option<String> getLoginFromAttributeO(HttpServletRequestX req) {
        return Option.ofNullable(req.getAttribute(DiskLog4jRequestLog.LOGIN_ATTRIBUTE))
                .map(Object::toString);
    }

    public static Option<String> getUidFromAttributeO(HttpServletRequestX req) {
        return Option.ofNullable(req.getAttribute(DiskLog4jRequestLog.UID_ATTRIBUTE))
                .map(Object::toString);
    }
}
