package ru.yandex.chemodan.util.bender;

import org.junit.Test;

import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.parse.BenderJsonParser;
import ru.yandex.misc.bender.parse.BenderParserException;
import ru.yandex.misc.io.RuntimeIoException;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 * @see <a href="https://st.yandex-team.ru/CHEMODAN-32789#1478528967000">CHEMODAN-32789</a>
 */
public class BenderTest {
    private final BenderJsonParser<BendableObject> parser = Bender.parser(BendableObject.class);

    @Test
    public void ok() {
        Assert.equals(
                new BendableObject("value", 0),
                parser.parseJson("{\"string\":\"value\",\"integer\":0}")
        );
    }

    @Test(expected = RuntimeIoException.class)
    public void runtimeExceptionOnRandomString() {
        parser.parseJson(Random2.threadLocal().nextAlnum(30));
    }

    @Test(expected = RuntimeIoException.class)
    public void runtimeExceptionOnWrongFormat() {
        parser.parseJson("{\"string\":value,\"integer\":0}");
    }

    @Test(expected = BenderParserException.class)
    public void benderParserExceptionOnWrongFieldName() {
        parser.parseJson("{\"string2\":\"value\",\"integer\":0}");
    }

    @Test(expected = BenderParserException.class)
    public void runtimeExceptionOnWrongValue() {
        parser.parseJson("{\"string\":\"value\",\"integer\":\"asd\"}");
    }

    @Bendable
    private static class BendableObject extends DefaultObject {
        @BenderPart(name = "string")
        public final String string;

        @BenderPart(name = "integer")
        public final int integer;

        BendableObject(String string, int integer) {
            this.string = string;
            this.integer = integer;
        }
    }
}
