package ru.yandex.chemodan.util.bender;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;

import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.bender.JsonValueMarshaller;
import ru.yandex.commune.json.bender.JsonValueUnmarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.bender.parse.JacksonJsonNodeWrapper;
import ru.yandex.misc.bender.serialize.BenderJsonGeneratorWrapper;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.io.IoUtils;

/**
 * @author dbrylev
 */
public class BenderUtils {

    public static final BenderParserSerializer<JsonObject> jsonObjectParserSerializer =
            new BenderMapper(new BenderConfiguration(
                    new BenderSettings(MembersToBind.WITH_ANNOTATIONS),
                    CustomMarshallerUnmarshallerFactoryBuilder.cons()
                            .add(JsonObject.class, new JsonValueMarshaller(), new JsonValueUnmarshaller())
                            .build()
            )).createParserSerializer(JsonObject.class);

    public static BenderJsonNode parseNode(JsonParser parser) {
        JsonNode node;
        try {
            node = new ObjectMapper().readTree(parser);
        } catch (IOException e) {
            throw IoUtils.translate(e);
        }
        return new JacksonJsonNodeWrapper(node);
    }

    public static <T> JsonObject toJsonObject(BenderSerializer<T> serializer, T bendable) {
        TokenBuffer buffer = new TokenBuffer(null, false);
        serializer.serializeJson(bendable, new BenderJsonGeneratorWrapper(buffer));

        return jsonObjectParserSerializer.getParser().parseJson(parseNode(buffer.asParser()));
    }

    public static <T> T fromJsonObject(BenderParser<T> parser, JsonObject object) {
        TokenBuffer buffer = new TokenBuffer(null, false);
        jsonObjectParserSerializer.getSerializer().serializeJson(object, new BenderJsonGeneratorWrapper(buffer));

        return parser.parseJson(parseNode(buffer.asParser()));
    }

    public static String serialize(JsonObject object) {
        return new String(jsonObjectParserSerializer.getSerializer().serializeJson(object));
    }
}
