package ru.yandex.chemodan.util.bender;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

import ru.yandex.misc.bender.parse.simpleType.SimpleTypeUnmarshallerSupport;
import ru.yandex.misc.time.TimeUtils;

/**
 * @author yashunsky
 */
public class HumanReadableDurationUnmarshaller extends SimpleTypeUnmarshallerSupport {

    private static final DateTimeFormatter timeFormatter = ISODateTimeFormat.hourMinuteSecond();

    @Override
    public Object convert(String o) {
        try {
            // millis and seconds
            return Duration.millis((long) (Float.parseFloat(o) * 1000));
        } catch (NumberFormatException ignored) {
        }

        try {
            // minutes and hours
            Instant parseResult = timeFormatter.parseDateTime(o).toInstant();
            Instant base = timeFormatter.parseDateTime("00:00:00").toInstant();

            return new Duration(base, parseResult);
        } catch (IllegalArgumentException ignored) {
        }

        try {
            // days
            long days = Long.parseLong(o.substring(0, o.indexOf(" day")));
            return Duration.standardDays(days);
        } catch (IllegalArgumentException | StringIndexOutOfBoundsException ignored) {
        }

        try {
            //TimeUtils
            return TimeUtils.toDuration(o);
        } catch (IllegalArgumentException ignored) {
        }

        throw new IllegalArgumentException("Couldn't parse " + o);
    }
}
