package ru.yandex.chemodan.util.bender;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

import ru.yandex.misc.bender.parse.simpleType.SimpleTypeUnmarshallerSupport;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ISODateTimeUnmarshaller extends SimpleTypeUnmarshallerSupport {
    private final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();

    private final Pattern2 noMsPattern = Pattern2.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}Z");

    @Override
    public DateTime convert(String o) {
        try {
            return dateTimeFormatter.parseDateTime(o);
        } catch (IllegalArgumentException e) {
            if (noMsPattern.matches(o)) {
                return convert(o.replaceAll("Z", ".000Z"));
            } else {
                throw e;
            }
        }
    }
}
