package ru.yandex.chemodan.util.bender;

import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

/**
 * @author yashunsky
 */
public class ISODateTimeUnmarshallerTest {
    private final ISODateTimeUnmarshaller unmarshaller = new ISODateTimeUnmarshaller();

    @Test
    public void normalCase() {
        DateTime dt = unmarshaller.convert("2018-10-12T07:51:07.123Z");
        Assert.assertEquals(1539330667123L, dt.getMillis());
    }

    @Test
    public void supportMsMissing() {
        DateTime dt = unmarshaller.convert("2018-10-12T07:51:07Z");
        Assert.assertEquals(1539330667000L, dt.getMillis());
    }
}
