package ru.yandex.chemodan.util.bender;

import org.joda.time.Instant;

import ru.yandex.misc.bender.parse.simpleType.SimpleTypeUnmarshallerSupport;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ISOInstantUnmarshaller extends SimpleTypeUnmarshallerSupport {
    private final ISODateTimeUnmarshaller dateTimeUnmarshaller = new ISODateTimeUnmarshaller();

    @Override
    public Instant convert(String o) {
        return dateTimeUnmarshaller.convert(o)
                .toInstant();
    }
}
