package ru.yandex.chemodan.util.bender;

import org.w3c.dom.Node;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.PartPosition;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.FieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.RootLevelUnmarshaller;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.misc.bender.parse.XmlOrJsonNode;

/**
 * @author dbrylev
 */
public interface JsonRootLevelUnmarshaller extends FieldLevelUnmarshaller, RootLevelUnmarshaller {

    @Override
    default ParseResult<Object> parseO(XmlOrJsonNode node, PartPosition pp, UnmarshallerContext context) {
        if (node.isXml()) {
            return parseXmlNode(node.getXml(), context);
        }

        Option<BenderJsonNode> fieldO;

        if (pp instanceof PartPosition.Ordinary) {
            PartPosition.Ordinary ordinary = (PartPosition.Ordinary) pp;
            String fieldName = ordinary.getWrapperName().getOrElse(ordinary.getName()).getLocalPartJson();

            fieldO = node.getJson().getField(fieldName);
        } else {
            fieldO = Option.of(node.getJson());
        }
        return fieldO.isPresent() ? parseJsonNode(fieldO.get(), context) : ParseResult.result(Option.empty());
    }

    @Override
    default ParseResult<Object> parseXmlNode(Node node, UnmarshallerContext context) {
        throw new UnsupportedOperationException("xml is not supported");
    }
}
