package ru.yandex.chemodan.util.bender;

import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactory;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryUtils;

/**
 * @author dbrylev
 */
public class UnderscoreNamesBenderConfiguration {

    public static BenderConfiguration extend(BenderConfiguration configuration) {
        return cons(configuration.getSettings(), configuration.getMarshallerUnmarshallerFactory());
    }

    public static BenderConfiguration cons(BenderSettings settings, CustomMarshallerUnmarshallerFactory baseFactory) {
        return new BenderConfiguration(
                settings,
                CustomMarshallerUnmarshallerFactoryUtils.combine(
                        new UnderscoreNamesMarshallerUnmarshallerFactory(),
                        baseFactory
                )
        );
    }
}
