package ru.yandex.chemodan.util.bender;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.parse.BenderJsonNode;

/**
 * @author dbrylev
 */
public class UnderscoreNamesBenderJsonNode extends DelegatedBenderJsonNode {

    private final UnderscoreNamesTranslator translator;

    public UnderscoreNamesBenderJsonNode(BenderJsonNode node, UnderscoreNamesTranslator translator) {
        super(node);
        this.translator = translator;
    }

    private UnderscoreNamesBenderJsonNode wrap(BenderJsonNode node) {
        return new UnderscoreNamesBenderJsonNode(node, translator);
    }

    @Override
    public Option<BenderJsonNode> getField(String fieldName) {
        return super.getField(translator.underscore(fieldName)).map(this::wrap);
    }

    @Override
    public ListF<BenderJsonNode> getArrayElements() {
        return super.getArrayElements().map(this::wrap);
    }
}
