package ru.yandex.chemodan.util.bender;

import ru.yandex.misc.bender.serialize.BenderJsonWriter;

/**
 * @author dbrylev
 */
public class UnderscoreNamesBenderJsonWriter extends DelegatedBenderJsonWriter {

    private final UnderscoreNamesTranslator translator;

    public UnderscoreNamesBenderJsonWriter(BenderJsonWriter writer, UnderscoreNamesTranslator translator) {
        super(writer);
        this.translator = translator;
    }

    @Override
    public void writeFieldName(String name) {
        super.writeFieldName(translator.underscore(name));
    }
}
