package ru.yandex.chemodan.util.bender;

import org.apache.commons.lang3.NotImplementedException;

import ru.yandex.commune.mongo3.bender.MongoObjectWriter;
import ru.yandex.commune.mongo3.bender.MongoValueNode;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingJsonCallback;
import ru.yandex.misc.bender.internal.pojo.PojoMarshallingXmlCallback;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.FieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.EmptyPojoMarshallingJsonCallback;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;
import ru.yandex.misc.bender.serialize.ToFieldWithCallbackMarshaller;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.xml.stream.XmlWriter;

/**
 * @author dbrylev
 */
public class UnderscoreNamesMarshallerUnmarshaller extends ToFieldMarshallerSupport
        implements ToFieldWithCallbackMarshaller, JsonFieldLevelUnmarshaller
{
    private final ToFieldWithCallbackMarshaller marshaller;
    private final FieldLevelUnmarshaller unmarshaller;
    private final UnderscoreNamesTranslator translator;

    public UnderscoreNamesMarshallerUnmarshaller(
            ToFieldWithCallbackMarshaller marshaller, UnderscoreNamesTranslator translator)
    {
        this.marshaller = marshaller;
        this.unmarshaller = null;
        this.translator = translator;
    }

    public UnderscoreNamesMarshallerUnmarshaller(
            FieldLevelUnmarshaller unmarshaller, UnderscoreNamesTranslator translator)
    {
        this.marshaller = null;
        this.unmarshaller = unmarshaller;
        this.translator = translator;
    }

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        writeJsonToFieldWithCallback(writer, fieldValue, new EmptyPojoMarshallingJsonCallback(), context);
    }

    @Override
    public void writeJsonToFieldWithCallback(
            BenderJsonWriter writer, Object object,
            PojoMarshallingJsonCallback callback, MarshallerContext context)
    {
        if (writer instanceof MongoObjectWriter) {
            if (!(writer instanceof UnderscoreNamesMongoObjectWriter)) {
                writer = new UnderscoreNamesMongoObjectWriter((MongoObjectWriter) writer, translator);
            }
        } else if (!(writer instanceof UnderscoreNamesBenderJsonWriter)) {
            writer = new UnderscoreNamesBenderJsonWriter(writer, translator);
        }
        getMarshaller().writeJsonToFieldWithCallback(writer, object, callback, context);
    }

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode json, UnmarshallerContext context) {
        if (json instanceof MongoValueNode) {
            if (!(json instanceof UnderscoreNamesMongoValueNode)) {
                json = new UnderscoreNamesMongoValueNode((MongoValueNode) json, translator);
            }
        } else if (!(json instanceof UnderscoreNamesBenderJsonNode)) {
            json = new UnderscoreNamesBenderJsonNode(json, translator);
        }
        return getUnmarshaller().parseJsonNode(json, context);
    }

    @Override
    public void writeXmlToFieldWithCallback(
            XmlWriter writer, Object fieldValue,
            PojoMarshallingXmlCallback callback, MarshallerContext context)
    {
        throw new NotImplementedException("xml is not implemented");
    }

    private ToFieldWithCallbackMarshaller getMarshaller() {
        Check.notNull(marshaller);
        return marshaller;
    }

    private FieldLevelUnmarshaller getUnmarshaller() {
        Check.notNull(unmarshaller);
        return unmarshaller;
    }
}
