package ru.yandex.chemodan.util.bender;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.ThreadLocalX;
import ru.yandex.misc.bender.BenderUtils;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactory;
import ru.yandex.misc.bender.parse.FieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.MainUnmarshallerFactory;
import ru.yandex.misc.bender.parse.Unmarshaller;
import ru.yandex.misc.bender.serialize.MainMarshallerFactory;
import ru.yandex.misc.bender.serialize.Marshaller;
import ru.yandex.misc.bender.serialize.ToFieldWithCallbackMarshaller;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.reflection.TypeX;

/**
 * @author dbrylev
 */
public class UnderscoreNamesMarshallerUnmarshallerFactory implements CustomMarshallerUnmarshallerFactory {

    private final ThreadLocalX<TypeX> customizing = new ThreadLocalX<>();

    private final UnderscoreNamesTranslator translator = new UnderscoreNamesTranslator();

    @Override
    public Option<Unmarshaller> createCustomUnmarshaller(
            BenderSettings settings, MainUnmarshallerFactory mainUnmarshallerFactory, TypeX type)
    {
        if (customizing.getO().isPresent()) {
            Check.some(type, customizing.getO());

            customizing.remove();
            return Option.empty();
        }
        if (type.isClass() && BenderUtils.hasBendable(type.asClass())) {
            customizing.set(type);
            Unmarshaller original = mainUnmarshallerFactory.createUnmarshaller(type);

            if (original instanceof FieldLevelUnmarshaller) {
                return Option.of(new UnderscoreNamesMarshallerUnmarshaller(
                        (FieldLevelUnmarshaller) original, translator));
            }
        }
        return Option.empty();
    }

    @Override
    public Option<Marshaller> createCustomMarshaller(
            BenderSettings settings, MainMarshallerFactory mainMarshallerFactory, TypeX type)
    {
        if (customizing.getO().isPresent()) {
            Check.some(type, customizing.getO());

            customizing.remove();
            return Option.empty();
        }
        if (type.isClass() && BenderUtils.hasBendable(type.asClass())) {
            customizing.set(type);
            Marshaller original = mainMarshallerFactory.createMarshaller(type);

            if (original instanceof ToFieldWithCallbackMarshaller) {
                return Option.of(new UnderscoreNamesMarshallerUnmarshaller(
                        (ToFieldWithCallbackMarshaller) original, translator));
            }
        }
        return Option.empty();
    }
}
