package ru.yandex.chemodan.util.bender;

import lombok.experimental.Delegate;

import ru.yandex.commune.mongo3.bender.MongoObjectWriter;

/**
 * @author dbrylev
 */
public class UnderscoreNamesMongoObjectWriter extends MongoObjectWriter {

    @Delegate(excludes = FieldWriter.class)
    private final MongoObjectWriter writer;
    private final UnderscoreNamesTranslator translator;

    public UnderscoreNamesMongoObjectWriter(MongoObjectWriter writer, UnderscoreNamesTranslator translator) {
        this.writer = writer;
        this.translator = translator;
    }

    @Override
    public void writeFieldName(String name) {
        writer.writeFieldName(translator.underscore(name));
    }

    private interface FieldWriter {
        void writeFieldName(String name);
    }
}
