package ru.yandex.chemodan.util.bender;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.mongo3.bender.MongoValueNode;
import ru.yandex.misc.bender.parse.BenderJsonNode;

/**
 * @author dbrylev
 */
public class UnderscoreNamesMongoValueNode extends MongoValueNode {

    private final UnderscoreNamesTranslator translator;

    public UnderscoreNamesMongoValueNode(MongoValueNode value, UnderscoreNamesTranslator translator) {
        super(value.getBsonValue());
        this.translator = translator;
    }

    private UnderscoreNamesMongoValueNode cons(BenderJsonNode node) {
        return new UnderscoreNamesMongoValueNode((MongoValueNode) node, translator);
    }

    @Override
    public Option<BenderJsonNode> getField(String fieldName) {
        return super.getField(translator.underscore(fieldName)).map(this::cons);
    }

    @Override
    public ListF<BenderJsonNode> getArrayElements() {
        return super.getArrayElements().map(this::cons);
    }
}
