package ru.yandex.chemodan.util.bender;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.misc.lang.CamelWords;

/**
 * @author dbrylev
 */
public class UnderscoreNamesTranslator {

    private final MapF<String, String> namesCache = Cf.concurrentHashMap();

    public String underscore(String name) {
        return namesCache.computeIfAbsent(name, n -> CamelWords.parse(n).toDbName());
    }
}
