package ru.yandex.chemodan.util.blackbox;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.joda.time.DateTimeZone;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxDbFields;
import ru.yandex.misc.net.LocalhostUtils;
import ru.yandex.misc.time.MoscowTime;

@Slf4j
@RequiredArgsConstructor
public class UserTimezoneHelper {
    private final Blackbox2 blackbox2;

    public DateTimeZone getUserTimezone(long uid) {
        try {
            return getUserTimezone(PassportUid.cons(uid));
        } catch (Exception e) {
            log.warn("Couldn't get timezone for user " + uid + ", use Moscow tz as default", e);
            return MoscowTime.TZ;
        }
    }

    public DateTimeZone getUserTimezone(PassportUid uid) {
        try {
            String timeZoneId = blackbox2.query()
                    .userInfo(LocalhostUtils.localAddress(), uid, Cf.list(BlackboxDbFields.TIMEZONE_DB_FIELD))
                    .getDbFields()
                    .getTs(BlackboxDbFields.TIMEZONE_DB_FIELD);

            return DateTimeZone.forID(timeZoneId);
        } catch (Exception e) {
            log.warn("Couldn't get timezone for user " + uid + ", use Moscow tz as default", e);
            return MoscowTime.TZ;
        }
    }
}
