package ru.yandex.chemodan.util.bookinfo;

import ru.yandex.chemodan.util.search.SearchResult;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class BookInfoFormatter {
    public String format(PassportUid uid, SearchResult.SearchItem searchItem) {
        StringBuilder sb = new StringBuilder();
        addIntermediateCsvValue(sb, uid.toString());
        addIntermediateCsvValue(sb, searchItem.title.getOrElse(""));
        addIntermediateCsvValue(sb, searchItem.author.getOrElse(""));
        addIntermediateCsvValue(sb, searchItem.filename.getOrElse(""));
        addIntermediateCsvValue(sb, searchItem.extension.getOrElse(""));
        addFinalCsvValue(sb, searchItem.md5.getOrElse(""));
        return sb.toString();
    }

    private void addIntermediateCsvValue(StringBuilder sb, String value) {
        addFinalCsvValue(sb, value.replaceAll("[\\t\\n\\r]+", " ").replace('"', '\''));
        sb.append(",");
    }
    private void addFinalCsvValue(StringBuilder sb, String value) {
        sb.append("\"").append(value).append("\"");
    }

}
