package ru.yandex.chemodan.util.bookinfo;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.search.SearchResult;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.test.Assert;

public class BookInfoFormatterTest {

    private BookInfoFormatter bookInfoFormatter = new BookInfoFormatter();

    @Test
    public void fullBookInfoFormatterTest() {
        SearchResult.SearchItem fullInfo = new SearchResult.SearchItem();
        fullInfo.author = Option.of("author");
        fullInfo.title = Option.of("title");
        fullInfo.filename = Option.of("filename");
        fullInfo.extension = Option.of("extension");
        fullInfo.md5 = Option.of("digest");
        PassportUid uid = new PassportUid(42L);

        String formatted = bookInfoFormatter.format(uid, fullInfo);
        Assert.equals(formatted, "\"42\",\"title\",\"author\",\"filename\",\"extension\",\"digest\"");
    }

    @Test
    public void bookInfoFormatterTest() {
        SearchResult.SearchItem fullInfo = new SearchResult.SearchItem();
        fullInfo.author = Option.of("author");
        fullInfo.title = Option.of("title");
        fullInfo.extension = Option.of("extension");
        fullInfo.md5 = Option.empty();
        fullInfo.filename = Option.empty();
        PassportUid uid = new PassportUid(42L);

        String formatted = bookInfoFormatter.format(uid, fullInfo);
        Assert.equals(formatted, "\"42\",\"title\",\"author\",\"\",\"extension\",\"\"");
    }
}
