package ru.yandex.chemodan.util.bookinfo;

import java.io.IOException;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.search.SearchClient;
import ru.yandex.chemodan.util.search.SearchResult;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.test.Assert;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.when;

@RunWith(MockitoJUnitRunner.class)
public class BookInfoGrabberTest {

    @Mock
    private SearchClient searchClient;
    private BookInfoFormatter bookInfoFormatter;

    private ListF<SearchResult.SearchItem> mockedInfo() {
        ListF<SearchResult.SearchItem> result = Cf.arrayList();
        SearchResult.SearchItem bookInfo1 = new SearchResult.SearchItem();
        bookInfo1.title = Option.of("title");
        bookInfo1.filename = Option.of("filename");
        bookInfo1.extension = Option.of("extension");
        bookInfo1.md5 = Option.of("md5");
        bookInfo1.author = Option.empty();

        result.add(bookInfo1);

        SearchResult.SearchItem bookInfo2 = new SearchResult.SearchItem();
        bookInfo2.title = Option.of("title2");
        bookInfo2.author = Option.of("authro2");
        bookInfo2.extension = Option.of("extension");
        bookInfo2.md5 = Option.of("md5");
        bookInfo2.filename = Option.empty();

        return result;
    }

    @Before
    public void init() {
        when(searchClient.getUserBooksInfo(any(PassportUid.class))).thenReturn(mockedInfo());
        bookInfoFormatter = new BookInfoFormatter();
    }

    @Test
    public void testGrab() throws IOException {
        File2 output = File2.createNewTmpDir().child("tmp");
        BookInfoGrabber grabber = new BookInfoGrabber(bookInfoFormatter, searchClient);
        grabber.grab(Cf.list(new PassportUid(42), new PassportUid(43)), output);
        ListF<SearchResult.SearchItem> infos = mockedInfo();
        ListF<String> actual = output.readLines();
        ListF<String> expected = Cf.arrayList();
        for (long uid : Cf.range(42, 44)) {
            for (SearchResult.SearchItem info : infos) {
                expected.add(bookInfoFormatter.format(new PassportUid(uid), info));
            }
        }
        Assert.assertListsEqual(expected, actual);
    }
}
