package ru.yandex.chemodan.util.date;

import org.joda.time.LocalDate;
import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class LocalDateRangeTest {
    @Test
    public void testToString() {
        Assert.equals(
                "2018-01-02_2018-02-03",
                new LocalDateRange(LocalDate.parse("2018-01-02"), LocalDate.parse("2018-02-03"))
                        .toString()
        );
    }

    @Test
    public void parseSafeOk() {
        Assert.some(
                new LocalDateRange(LocalDate.parse("1983-11-08"), LocalDate.parse("2018-04-26")),
                LocalDateRange.parseSafe("1983-11-08_2018-04-26")
        );
    }

    @Test
    public void parseSafeError() {
        Assert.none(LocalDateRange.parseSafe("abcdef123456"));
    }

    @Test
    public void overlaps() {
        Assert.isTrue(
                LocalDateRange.parse("2018-04-20", "2018-04-26")
                        .overlaps(LocalDateRange.parse("2018-04-15", "2018-04-21"))
        );
        Assert.isTrue(
                LocalDateRange.parse("2018-04-20", "2018-04-26")
                        .overlaps(LocalDateRange.parse("2018-04-24", "2018-04-28"))
        );
        Assert.isTrue(
                LocalDateRange.parse("2018-04-20", "2018-04-26")
                        .overlaps(LocalDateRange.parse("2018-04-21", "2018-04-25"))
        );
        Assert.isTrue(
                LocalDateRange.parse("2018-04-20", "2018-04-26")
                        .overlaps(LocalDateRange.parse("2018-04-20", "2018-04-26"))
        );
        Assert.isTrue(
                LocalDateRange.parse("2018-04-20", "2018-04-26")
                        .overlaps(LocalDateRange.parse("2018-04-20", "2018-04-25"))
        );
        Assert.isTrue(
                LocalDateRange.parse("2018-04-20", "2018-04-26")
                        .overlaps(LocalDateRange.parse("2018-04-21", "2018-04-26"))
        );
    }

    @Test
    public void notOverlaps() {
        Assert.isFalse(
                LocalDateRange.parse("2018-04-20", "2018-04-26")
                        .overlaps(LocalDateRange.parse("2018-04-15", "2018-04-19"))
        );
        Assert.isFalse(
                LocalDateRange.parse("2018-04-20", "2018-04-26")
                        .overlaps(LocalDateRange.parse("2018-04-27", "2018-04-29"))
        );
    }

    @Test
    public void subsetOf() {
        Assert.isTrue(
                LocalDateRange.parse("2018-04-22", "2018-04-23")
                        .subsetOf(LocalDateRange.parse("2018-04-21", "2018-04-24"))
        );
        Assert.isTrue(
                LocalDateRange.parse("2018-04-22", "2018-04-23")
                        .subsetOf(LocalDateRange.parse("2018-04-22", "2018-04-23"))
        );
        Assert.isTrue(
                LocalDateRange.parse("2018-04-22", "2018-04-23")
                        .subsetOf(LocalDateRange.parse("2018-04-22", "2018-04-24"))
        );
        Assert.isTrue(
                LocalDateRange.parse("2018-04-22", "2018-04-23")
                        .subsetOf(LocalDateRange.parse("2018-04-21", "2018-04-23"))
        );

    }
}
