package ru.yandex.chemodan.util.djvugrabber;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.util.search.SearchClient;
import ru.yandex.chemodan.util.search.SearchResult;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.io.file.File2;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class DjvuMulcaIdGrabber {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("You should specify path to file with uids");
        }

        File2 input = new File2(args[0]);
        File2 output = new File2("ids.txt");
        ListF<PassportUid> uids = input.readLines().map(Cf.Long.parseF().andThen(PassportUid.consF()));
        SetF<String> mulcaIds = Cf.hashSet();
        SetF<SearchResult.SearchItem> results = Cf.hashSet();
        SearchClient sc = new SearchClient("search.disk.yandex.net");

        for (PassportUid uid : uids) {
            try {
                if (mulcaIds.size() > 100) {
                    break;
                } else {
                    Option<SearchResult.SearchItem> res = sc.getFirstDjvuInfo(uid);
                    if (res.isPresent()) {
                        mulcaIds.add(res.get().stid.get());
                        results.add(res.get());

                        if (mulcaIds.size() % 10 == 0) {
                            System.out.println(mulcaIds.size() + " djvu founded");
                        }
                    }
                }
            } catch (Exception e) {
                System.err.println(e);
            }
        }

        BenderSerializer<SearchResult.SearchItem> serializer =
                Bender.cons(SearchResult.SearchItem.class).getSerializer();
        output.write(serializer.serializeListJson(results.toList()));

    }
}
