package ru.yandex.chemodan.util.docinfo;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.util.search.AbstractInfoFormatter;
import ru.yandex.chemodan.util.search.SearchResult;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
public class DocumentInfoFormatter extends AbstractInfoFormatter {

    @Override
    public String format(PassportUid uid, SearchResult.SearchItem item) {
        String ctime = EMPTY_FIELD;
        if (item.ctimeInSec.isPresent()) {
            ctime = DATE_FORMATTER.print(item.ctimeInSec.get() * 1000);
        }
        return StringUtils.format(
                "{}\t{}\t{}\t{}\t{}",
                uid,
                item.path.getOrElse(EMPTY_FIELD),
                DATE_FORMATTER.print(item.mtimeInSec.get() * 1000),
                ctime,
                item.size.map(Cf.Long.toStringF()).getOrElse(EMPTY_FIELD));
    }
}
