package ru.yandex.chemodan.util.encrypt;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.lang.CharsetUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HmacDigestUtil {
    private static final String ALGORITHM = "HmacSHA256";

    public static byte[] sign(String message, String password) {
        try {
            return signUnsafe(message, password);
        } catch (NoSuchAlgorithmException | InvalidKeyException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    private static byte[] signUnsafe(String message, String password) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec keySpec = new SecretKeySpec(password.getBytes(CharsetUtils.UTF8_CHARSET), ALGORITHM);
        Mac mac = Mac.getInstance(ALGORITHM);
        mac.init(keySpec);
        return mac.doFinal(message.getBytes(CharsetUtils.UTF8_CHARSET));
    }
}
