package ru.yandex.chemodan.util.encrypt;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.lang.CharsetUtils;
import ru.yandex.misc.random.Random2;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class OpenSslAes256CbcCipherUtil {
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";

    public static final byte[] MAGIC = "Salted__".getBytes();

    public static final int OPENSSL_PKCS5_SALT_LEN = 8;

    @SuppressWarnings("unused")
    public static byte[] encrypt(String message, String pwd) {
        return encrypt(message, pwd, Random2.threadLocal().nextBytes(OPENSSL_PKCS5_SALT_LEN));
    }

    public static byte[] encrypt(String message, String password, byte[] salt) {
        try {
            return encryptUnchecked(message, password, salt);
        } catch (Exception e) {
            throw new CryptException(message, "encrypting", ExceptionUtils.translate(e));
        }
    }

    private static byte[] encryptUnchecked(String message, String password, byte[] salt) throws Exception {
        byte[] encrypted = cryptUnchecked(
                message.getBytes(CharsetUtils.UTF8_CHARSET), password, salt, Cipher.ENCRYPT_MODE);
        return join(MAGIC, salt, encrypted);
    }

    public static String decrypt(byte[] message, String password) {
        try {
            return decryptUnchecked(message, password);
        } catch (Exception e) {
            throw new CryptException(message, "decrypting", ExceptionUtils.translate(e));
        }
    }

    private static String decryptUnchecked(byte[] data, String password) throws Exception {
        byte[] encrypted = slice(data, MAGIC.length + OPENSSL_PKCS5_SALT_LEN);
        return new String(
                cryptUnchecked(encrypted, password, extractSalt(data), Cipher.DECRYPT_MODE),
                CharsetUtils.UTF8_CHARSET
        );
    }

    static byte[] extractSalt(byte[] data) {
        return slice(data, MAGIC.length, OPENSSL_PKCS5_SALT_LEN);
    }

    private static byte[] cryptUnchecked(byte[] message, String password, byte[] salt, int mode) throws Exception {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        Tuple2<byte[], byte[]> keyAndIV = OpenSslEvpBytesToKeyUtil.bytesToKey(
                cipher.getBlockSize(),
                salt,
                password.getBytes(CharsetUtils.UTF8_CHARSET)
        );
        cipher.init(
                mode,
                new SecretKeySpec(keyAndIV.get1(), "AES"),
                new IvParameterSpec(keyAndIV.get2())
        );
        return cipher.doFinal(message);
    }

    private static byte[] join(byte[]... srcs) {
        Integer length = Cf.list(srcs)
                .map(bytes -> bytes.length)
                .reduceLeft((len1, len2) -> len1 + len2);
        byte[] result = new byte[length];
        int dstPos = 0;
        for(byte[] src : srcs) {
            System.arraycopy(src, 0, result, dstPos, src.length);
            dstPos += src.length;
        }
        return result;
    }

    private static byte[] slice(byte[] src, int offset) {
        return slice(src, offset, src.length - offset);
    }

    private static byte[] slice(byte[] src, int offset, int length) {
        byte[] result = new byte[length];
        System.arraycopy(src, offset, result, 0, length);
        return result;
    }

    private static class CryptException extends RuntimeException {
        CryptException(byte[] data, String action, Throwable ex) {
            this(new String(data, CharsetUtils.UTF8_CHARSET), action, ex);
        }

        CryptException(String data, String action, Throwable ex) {
            super(String.format("Error while %s '%s'", action, data), ex);
        }
    }
}
