package ru.yandex.chemodan.util.encrypt;

import org.junit.Ignore;
import org.junit.Test;

import ru.yandex.misc.codec.FastBase64Coder;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 * @see <a href="http://stackoverflow.com/questions/11783062/how-to-decrypt-file-in-java-encrypted-with-openssl-command-using-aes/11786924#11786924">
 *     How to decrypt file in Java encrypted with openssl command using AES?</a>
 */
public class OpenSslAes256CbcCipherUtilTest {
    private static final String DECODED = "Pack up the moon";

    // echo -n 'Pack up the moon' | openssl aes-256-cbc -e -md sha256 -a -k 'secret'
    private static final String ENCODED = "U2FsdGVkX19F116bzVCyVOON3IL1xR5h0vNaK6woQ/HYmxUH2oeolvPHRel4BwhV";

    private static final String PASSWORD = "secret";

    @Test
    @Ignore // JCE Unlimited Strength Jurisdiction Policy Files is needed for test to work
    public void testEncode() {
        Assert.equals(ENCODED, FastBase64Coder.encodeToString(OpenSslAes256CbcCipherUtil.encrypt(DECODED, PASSWORD, extractSalt(ENCODED))));
    }

    @Test
    @Ignore // JCE Unlimited Strength Jurisdiction Policy Files is needed for test to work
    public void testDecode() {
        Assert.equals(DECODED, OpenSslAes256CbcCipherUtil.decrypt(FastBase64Coder.decode(ENCODED), PASSWORD));
    }

    private static byte[] extractSalt(String openSslOutput) {
        return OpenSslAes256CbcCipherUtil.extractSalt(FastBase64Coder.decode(openSslOutput));
    }
}
