package ru.yandex.chemodan.util.encrypt;

import ru.yandex.misc.codec.FastBase64Coder;
import ru.yandex.misc.codec.Hex;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class OpenSslAes256CbcCrypter {
    private final String password;

    public OpenSslAes256CbcCrypter(String password) {
        this.password = password;
    }

    public String encrypt(String message) {
        return FastBase64Coder.encodeForUrl(OpenSslAes256CbcCipherUtil.encrypt(message, password));
    }

    public String decrypt(String message) {
        return OpenSslAes256CbcCipherUtil.decrypt(FastBase64Coder.decodeFromUrl(message), password);
    }

    public String sign(String message) {
        return Hex.encode(HmacDigestUtil.sign(message, password));
    }
}
