package ru.yandex.chemodan.util.encrypt;

import java.security.MessageDigest;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.ExceptionUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class OpenSslEvpBytesToKeyUtil {
    private static final String KEY_HASH_ALGORITHM = "SHA-256";

    private static final int KEY_SIZE = 256 / Byte.SIZE;

    private static final int ITERATIONS = 1;

    public static Tuple2<byte[], byte[]> bytesToKey(int iv_len, byte[] salt, byte[] data) {
        try {
            return bytesToKeyChecked(iv_len, salt, data);
        } catch (Exception e) {
            throw ExceptionUtils.translate(e);
        }
    }

    private static Tuple2<byte[], byte[]> bytesToKeyChecked(int iv_len, byte[] salt, byte[] data) throws Exception {
        MessageDigest md = MessageDigest.getInstance(KEY_HASH_ALGORITHM);
        byte[] key = new byte[KEY_SIZE];
        int key_ix = 0;
        byte[] iv = new byte[iv_len];
        int iv_ix = 0;
        byte[] md_buf = null;
        int nkey = KEY_SIZE;
        int niv = iv_len;

        for(;;) {
            md.reset();
            if (md_buf != null) {
                md.update(md_buf);
            }
            md.update(data);
            md.update(salt,0,8);
            md_buf = md.digest();
            for(int i = 1; i < ITERATIONS; i++) {
                md.reset();
                md.update(md_buf);
                md_buf = md.digest();
            }
            int i = 0;
            if(nkey > 0) {
                for(;;) {
                    if(nkey == 0) break;
                    if(i == md_buf.length) break;
                    key[key_ix++] = md_buf[i];
                    nkey--;
                    i++;
                }
            }
            if(niv > 0 && i != md_buf.length) {
                for(;;) {
                    if(niv == 0) break;
                    if(i == md_buf.length) break;
                    iv[iv_ix++] = md_buf[i];
                    niv--;
                    i++;
                }
            }

            if (nkey == 0 && niv == 0) {
                break;
            }
        }

        for (int i = 0; i < md_buf.length; i++) {
            md_buf[i] = 0;
        }

        return new Tuple2<>(key, iv);
    }
}
