package ru.yandex.chemodan.util.exception;

import ru.yandex.commune.a3.action.A3Exception;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;

/**
 * @author tolmalev
 */
public class A3ExceptionWithStatus extends A3Exception implements HttpStatusCodeSource {
    private final int status;

    public A3ExceptionWithStatus(String name, int status) {
        super(name);
        this.status = status;
    }

    public A3ExceptionWithStatus(String name, String message, int status) {
        super(name, message);
        this.status = status;
    }

    public A3ExceptionWithStatus(String name, String message, Throwable cause, int status) {
        super(name, message, cause);
        this.status = status;
    }

    public A3ExceptionWithStatus(String name, Throwable cause, int status) {
        super(name, cause);
        this.status = status;
    }

    @Override
    public int getHttpStatusCode() {
        return status;
    }
}
