package ru.yandex.chemodan.util.exception;

import ru.yandex.bolts.function.Function0;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.commune.a3.action.result.error.CommonErrorNames;
import ru.yandex.commune.a3.action.result.error.ErrorLogLevelSource;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Level;

/**
 * @author tolmalev
 */
public class NotFoundException extends A3ExceptionWithNoStackTrace implements HttpStatusCodeSource, ErrorLogLevelSource {
    private final Level level;

    public NotFoundException(String message) {
        this(message, Level.DEBUG);
    }

    public NotFoundException(String message, Level level) {
        super(CommonErrorNames.NOT_FOUND, message);
        this.level = level;
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_404_NOT_FOUND;
    }

    public static Function0<NotFoundException> consF(final String message) {
        return () -> new NotFoundException(message);
    }

    @Override
    public Level getErrorLogLevel() {
        return level;
    }
}
