package ru.yandex.chemodan.util.exception;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.bolts.collection.Option;

/**
 * @author ssytnik
 */
@SuppressWarnings("serial")
public class PermanentFailureWithCodeException extends PermanentFailureException {
    private final Option<Integer> statusCode;

    public PermanentFailureWithCodeException(String message, Exception cause, Option<Integer> statusCode) {
        super(message, cause);
        this.statusCode = statusCode;
    }

    public PermanentFailureWithCodeException(String message, Option<Integer> statusCode) {
        super(message);
        this.statusCode = statusCode;
    }

    public PermanentFailureWithCodeException(String message, int statusCode) {
        this(message, Option.of(statusCode));
    }

    @Override
    public String toString() {
        String message = getLocalizedMessage();
        return getClass().getName() +
                (getStatusCode().isPresent() ? "(code=" + getStatusCode().get() + ")" : "") +
                (message != null ? ": " + message : "");
    }

    private static final Pattern MESSAGE_WITH_CODE = Pattern.compile("^[\\w\\.]+Exception\\(code=(\\d+)\\)");

    public static Option<Integer> tryParseStatusCode(String s) {
        Matcher m = MESSAGE_WITH_CODE.matcher(s);
        if (m.lookingAt()) {
            return Option.of(Integer.valueOf(m.group(1)));
        } else {
            return Option.empty();
        }
    }

    public Option<Integer> getStatusCode() {
        return statusCode;
    }

}
