package ru.yandex.chemodan.util.exception;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.http.HttpException;
import ru.yandex.misc.test.Assert;

/**
 * @author ssytnik
 */
public class PermanentFailureWithCodeExceptionTest {

    @Test
    public void parseCode() {
        Assert.some(123, doParseCode(new PermanentFailureWithCodeException("abc", 123)));
        Assert.some(404, doParseCode(new PermanentHttpFailureException("upper", new HttpException(404, "inner"))));

        Assert.none(doParseCode(new PermanentFailureWithCodeException("no code", Option.empty())));
        Assert.none(doParseCode(new PermanentFailureException("other exception")));
    }

    private Option<Integer> doParseCode(Exception e) {
        return PermanentFailureWithCodeException.tryParseStatusCode(e.toString());
    }

}
