package ru.yandex.chemodan.util.exception;

import java.util.Map;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.http.HttpException;

/**
 * @author ssytnik
 */
@SuppressWarnings("serial")
public class PermanentHttpFailureException extends PermanentFailureWithCodeException {

    public final Option<String> responseBody;
    public final Map<String, String> headers;

    public PermanentHttpFailureException(String responseBody, String message, int statusCode,
            Map<String, String> headers)
    {
        super(message, statusCode);
        this.responseBody = Option.of(responseBody);
        this.headers = headers;
    }

    public PermanentHttpFailureException(String message, HttpException cause) {
        super(message, cause, cause.getStatusCode());
        this.responseBody = Option.empty();
        this.headers = Cf.map();
    }

    public PermanentHttpFailureException(String message, int statusCode) {
        super(message, statusCode);
        this.responseBody = Option.empty();
        this.headers = Cf.map();
    }

    public PermanentHttpFailureException(String responseBody, String message, HttpException cause) {
        super(message, cause, cause.getStatusCode());
        this.responseBody = Option.of(responseBody);
        this.headers = Cf.map();
    }

    public PermanentHttpFailureException(String responseBody, String message, int statusCode) {
        super(message, statusCode);
        this.responseBody = Option.of(responseBody);
        this.headers = Cf.map();
    }

}
