package ru.yandex.chemodan.util.exception;

import ru.yandex.chemodan.util.web.ErrorNames;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.commune.a3.action.result.error.ErrorLogLevelSource;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Level;

/**
 * @author tolmalev
 */
public class SchemaValidationException extends A3ExceptionWithNoStackTrace implements HttpStatusCodeSource,
        ErrorLogLevelSource
{
    public SchemaValidationException(String message) {
        super(ErrorNames.INVALID_SCHEMA, message);
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_400_BAD_REQUEST;
    }

    @Override
    public Level getErrorLogLevel() {
        return Level.WARN;
    }
}
