package ru.yandex.chemodan.util.http;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.filter.OncePerRequestFilter;

import ru.yandex.misc.web.servlet.SelfMappedFilter;

/**
 * @author friendlyevil
 */
public class CachedServletRequestFilter extends OncePerRequestFilter implements SelfMappedFilter {
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
            throws ServletException, IOException {
        filterChain.doFilter(new CachedHttpServletRequest(request), response);
    }

    @Override
    public String getUrlPattern() {
        return "*";
    }
}
