package ru.yandex.chemodan.util.http;

import ru.yandex.bolts.collection.Option;

/**
 * @author nshmakov
 */
public class ContentTypeUtils {

    public static boolean isVideoContentType(Option<String> contentType) {
        return contentType.isPresent() && isVideoContentType(contentType.get());
    }

    public static boolean isVideoContentType(String contentType) {
        return !contentType.equals("video/x-unknown") && contentType.startsWith("video/");
    }

}
