package ru.yandex.chemodan.util.http;

import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HttpException extends IllegalStateException {
    private final int statusCode;

    public HttpException(int statusCode) {
        this.statusCode = statusCode;
    }

    public boolean is5xx() {
        return HttpStatus.is5xx(statusCode);
    }

    public boolean hasStatusCode(int statusCode) {
        return this.statusCode == statusCode;
    }
}
