package ru.yandex.chemodan.util.http;

import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.junit.Test;

import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HttpExceptionResponseHandlerTest {
    @Test
    public void status2xxIsHandleWithoutErrorByDefault() {
        Object expectedResult = new Object();
        Assert.equals(expectedResult, handleResponse(HttpStatus.SC_200_OK, expectedResult));
        Assert.equals(expectedResult, handleResponse(HttpStatus.SC_204_NO_CONTENT, expectedResult));
    }

    @Test
    public void status4xxIsHandledWithErrorByDefault() {
        assertHandleResponseThrowsHttpExceptionWithStatus(HttpStatus.SC_400_BAD_REQUEST);
        assertHandleResponseThrowsHttpExceptionWithStatus(HttpStatus.SC_404_NOT_FOUND);
    }

    @Test
    public void status5xxIsHandledWithErrorByDefault() {
        assertHandleResponseThrowsHttpExceptionWithStatus(HttpStatus.SC_500_INTERNAL_SERVER_ERROR);
        assertHandleResponseThrowsHttpExceptionWithStatus(HttpStatus.SC_503_SERVICE_UNAVAILABLE);
    }

    @Test
    public void extraOkStatusIsHandledWithoutError() {
        Object expectedResult = new Object();
        int status = HttpStatus.SC_404_NOT_FOUND;
        Assert.equals(expectedResult, handleResponse(status, expectedResult, status));
    }

    private static void assertHandleResponseThrowsHttpExceptionWithStatus(int status) {
        Assert.assertThrows(
                () -> handleResponse(status, new Object()), HttpException.class, e -> e.hasStatusCode(status)
        );
    }

    private static Object handleResponse(int statusCode, Object expectedResult, int... extraStatuses) {
        HttpResponse resp = new BasicHttpResponse(
                new BasicStatusLine(HttpVersion.HTTP_1_1, statusCode, "")
        );
        return HttpExceptionResponseHandler.build(r -> expectedResult)
                .addOkStatuses(extraStatuses)
                .build()
                .handleResponse(resp);
    }
}
