package ru.yandex.chemodan.util.http;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.http.HttpHeaderNames;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author tolmalev
 */
public class RequestUtils {

    private final static Logger logger = LoggerFactory.getLogger(RequestUtils.class);

    public static Option<String> getIfMatch(HttpServletRequest request) {
        //TODO: check if someone uses If-Match in lowercase
        return HttpServletRequestX
                .wrap(request)
                .getHeaderO(HttpHeaderNames.IF_MATCH)
                .map(RequestUtils::unquoteIfMatch);
    }

    public static Option<Long> getIfMatchAsLong(HttpServletRequest request) {
        Option<String> ifMatch = getIfMatch(request);
        return parseToLong(ifMatch);
    }

    public static Option<String> getIfNonMatch(HttpServletRequest request) {
        return HttpServletRequestX
                .wrap(request)
                .getHeaderO(HttpHeaderNames.IF_NONE_MATCH)
                .map(RequestUtils::unquoteIfMatch);
    }

    public static Option<Long> getIfNonMatchAsLong(HttpServletRequest request) {
        Option<String> ifMatch = getIfNonMatch(request);
        return parseToLong(ifMatch);
    }

    private static Option<Long> parseToLong(Option<String> ifMatch) {
        try {
            return Option.x(ifMatch.mapToOptionalLong(Long::parseLong));
        } catch (NumberFormatException e) {
            logger.warn("can't parse header {}", e.getMessage());
            return Option.empty();
        }
    }

    public static String unquoteIfMatch(String value) {
        if (value.startsWith("\"")) {
            return StringUtils.removeEnd(StringUtils.removeStart(value, "\""), "\"");
        }
        return value;
    }
}
