package ru.yandex.chemodan.util.http;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.oauth.OauthClient;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author vavinov
 */
public class YandexUidCookieParser {
    public static final int MAX_YUID_LENGTH = 20;
    public static final String YANDEXUID_COOKIE_NAME = "yandexuid";

    /**
     * Retrieves Yandex UID code from request. Code may come in two ways: in cookies or as a header
     * containing all cookies as a string.
     * YandexUID is then abbreviated to it's expected length to prevent possible attacks.
     *
     * @param reqX request
     * @return yandexuid request cookie, as option.
     */
    public static Option<String> parseYandexUidCode(HttpServletRequestX reqX) {
        String cookie = reqX.getHeader(OauthClient.YA_CLIENT_COOKIE_HEADER);
        String yuid = reqX.getCookiesValuesMap().getOrElse(YANDEXUID_COOKIE_NAME, null);

        if (yuid == null && !StringUtils.isEmpty(cookie)) {
            String[] parsedCookies = cookie.split("\\;\\s*");
            String[] oneParsedCookie;
            for (int i = 0; i < parsedCookies.length && yuid == null; i++) {
                oneParsedCookie = parsedCookies[i].split("=");
                if (oneParsedCookie.length == 2 && YANDEXUID_COOKIE_NAME.equals(oneParsedCookie[0])) {
                    yuid = oneParsedCookie[1];
                }
            }
        }
        yuid = StringUtils.abbreviate(yuid, MAX_YUID_LENGTH);
        return Option.ofNullable(yuid);
    }
}
