package ru.yandex.chemodan.util.http.zora;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;

/**
 * @author yashunsky
 */
@AllArgsConstructor
@Getter
public class ZoraConfiguration {
    private final ListF<ZoraHeader> headers;

    public static ZoraConfiguration basic(ZoraHeader... otherHeaders) {
        return new ZoraConfiguration(Cf.list(new ZoraHeader.IgnorCerts(true),
                new ZoraHeader.ForceGzip()).plus(Cf.x(otherHeaders)));
    }
}
